/*
 * ContagionParameters.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef CONTAGIONPARAMETERS_H_
#define CONTAGIONPARAMETERS_H_



#include <StandardLibs.h>

typedef struct {
	double p;
	double q;

	int T; //duration (here the reference point is T_0 = 0)
	int T_value_min; //estimation for minmal duration

	int T_rel_end; // temporal moment of end of simulation (reference point) relative from first interaction
	int T_rel_start; //temporal moment od start of simulation relative from first interaction
	int T_start;
	int T_end;

	//T_start prior knowledge
	int prior_T_low_bound;
	int prior_T_high_bound;


	int randomize_parameters = 0; //default no randomization
	vector<double> T_distr_sample_noise;
	vector<double> norm_distr_sample_noise;
	int estimate_T_from_temporal_contacts = 0; // default value, otherwise we estimate T from data also
	vector<int> T_activity_times;

} contagion_param_struct;


void clear_epidemic_parameters(contagion_param_struct * cont_param);
double get_rnd_pq_value (vector<double> * sample, double exp_value);
int get_T_rnd_sample(vector<double> * T_distr_sample, int T_value);
double get_random_sample(vector<double> * sample);
int get_random_sample(vector<int> * sample);
double my_random_1();

#endif /* CONTAGIONPARAMETERS_H_ */
